/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.copy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import zigen.plugin.db.ui.actions.ITableViewEditorAction;
import zigen.plugin.db.ui.editors.ITableViewEditor;


abstract public class AbstractCopyAction extends Action implements ITableViewEditorAction {
	
	protected final String LINE_SEP = System.getProperty("line.separator");
	
	protected ITableViewEditor editor;
	
	protected IStructuredSelection selection;
	
	
	public void selectionChanged(ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
		} else {
			this.selection = null;
		}
	}
	
	
	public void setActiveEditor(ITableViewEditor targetEditor) {
		this.editor = targetEditor;
		
	}
	

}
